<?php

class MY_Controller extends CI_Controller
{

    public $headerpart;
    public $footerpart;
	public $template;
	public $assetspath;
	public $menuitem;
	
	public $admincss;
	public $adminjs;

    public function __construct()
    {
        parent::__construct();
		$this->template='theme/';
		$this->assetspath='assets/'.$this->template;
		
		define('THEMEPATH',APPPATH."views/".$this->template);
	
    }

   
	public function adminview($view, $data = NULL, $head = NULL,$foot = NULL)
    {
		$data['asseturl'] = $foot['asseturl'] =$head['asseturl'] = base_url('assets/admin/');
		
		$head['css']=$this->admincss();		
		$foot['js']=$this->adminjs();
		
		$this->load->view('admin/_parts/header', $head);
		$this->load->view('admin/_parts/sidemenu');
		$this->load->view('admin/_parts/topbar');
		
		$this->load->view('admin/' . $view, $data);
        
		$this->load->view('admin/_parts/footer', $foot);
    }
	
	
	public function merchantview($view, $data = NULL, $head = NULL,$foot = NULL)
    {
		$data['asseturl'] = $foot['asseturl'] =$head['asseturl'] = base_url('assets/admin/');
		
		$head['css']=$this->admincss();		
		$foot['js']=$this->adminjs();
		
		$this->load->view('merchant/_parts/header', $head);
		//$this->load->view('merchant/_parts/sidemenu');
		$this->load->view('merchant/_parts/topbar');
		
		$this->load->view('merchant/' . $view, $data);
        
		$this->load->view('merchant/_parts/footer', $foot);
    }
	
    
	public function adminloginview($view, $data = NULL, $head = NULL,$foot = NULL)
    {
		$data['asseturl'] = $foot['asseturl'] =$head['asseturl'] = base_url('assets/admin/');
		
		$head['css']=$this->admincss();		
		$foot['js']=$this->adminjs();
		
		$this->load->view('admin/_parts/header', $head);
		//$this->load->view('admin/_parts/sidemenu');
		//$this->load->view('admin/_parts/topbar');
		
		$this->load->view('admin/' . $view, $data);
        
		$this->load->view('admin/_parts/footer', $foot);
    }
	
	public function admincss(){
		$css='<link rel="icon" href="'.base_url('assets/admin/').'images/favicon.ico" type="image/x-icon"/>
			<link href="'.base_url('assets/admin/').'plugins/select2/css/select2.min.css" rel="stylesheet"/>
			<link href="'.base_url('assets/admin/').'plugins/inputtags/css/bootstrap-tagsinput.css" rel="stylesheet" />
			<link href="'.base_url('assets/admin/').'plugins/jquery-multi-select/multi-select.css" rel="stylesheet" type="text/css">
			<link href="'.base_url('assets/admin/').'plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet" type="text/css">
			<link href="'.base_url('assets/admin/').'plugins/bootstrap-touchspin/css/jquery.bootstrap-touchspin.css" rel="stylesheet" type="text/css">
			<link href="'.base_url('assets/admin/').'plugins/summernote/dist/summernote-bs4.css" rel="stylesheet"/>
			<link href="'.base_url('assets/admin/').'plugins/dropzone/css/dropzone.css" rel="stylesheet" type="text/css">
			<link href="'.base_url('assets/admin/').'plugins/simplebar/css/simplebar.css" rel="stylesheet"/>
			<link href="'.base_url('assets/admin/').'css/bootstrap.min.css" rel="stylesheet"/>
			<link href="'.base_url('assets/admin/').'plugins/bootstrap-datatable/css/dataTables.bootstrap4.min.css" rel="stylesheet" type="text/css">
			<link href="'.base_url('assets/admin/').'plugins/bootstrap-datatable/css/buttons.bootstrap4.min.css" rel="stylesheet" type="text/css">
			<link href="'.base_url('assets/admin/').'css/animate.css" rel="stylesheet" type="text/css"/>
			<link href="'.base_url('assets/admin/').'css/icons.css" rel="stylesheet" type="text/css"/>
			<link href="'.base_url('assets/admin/').'css/sidebar-menu.css" rel="stylesheet"/>
			<link href="'.base_url('assets/admin/').'css/app-style.css" rel="stylesheet"/>
			<link href="'.base_url('assets/admin/').'css/skins.css" rel="stylesheet"/>';	
			
			return $css;
	}
	
	public function adminjs(){
		$js ='<script src="'.base_url('assets/admin/').'js/jquery.min.js"></script>
			   <script src="'.base_url('assets/admin/').'js/popper.min.js"></script>
			   <script src="'.base_url('assets/admin/').'js/bootstrap.min.js"></script>
			   <script src="'.base_url('assets/admin/').'plugins/simplebar/js/simplebar.js"></script>
			   <script src="'.base_url('assets/admin/').'js/sidebar-menu.js"></script>
			   <script src="'.base_url('assets/admin/').'js/app-script.js"></script>
			   <script src="'.base_url('assets/admin/').'plugins/dropzone/js/dropzone.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-touchspin/js/jquery.bootstrap-touchspin.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-touchspin/js/bootstrap-touchspin-script.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/select2/js/select2.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/inputtags/js/bootstrap-tagsinput.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/jquery-multi-select/jquery.multi-select.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/jquery-multi-select/jquery.quicksearch.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/summernote/dist/summernote-bs4.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/jquery.dataTables.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/dataTables.bootstrap4.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/dataTables.buttons.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/buttons.bootstrap4.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/jszip.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/pdfmake.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/vfs_fonts.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/buttons.html5.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/buttons.print.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/bootstrap-datatable/js/buttons.colVis.min.js"></script>
				<script src="'.base_url('assets/admin/').'plugins/ckeditor/ckeditor.js"></script>';
		$js.="<script> var baseurl='".base_url()."'</script>";
		$js.='<script src="'.base_url('assets/admin/').'js/custom.js"></script>';
		$js.=" <script>
		// Add restrictions
		Dropzone.options.fileupload = {
		    url:'".base_url('admin/galleryplugin/imageupload')."',
			dataType:'JSON',
			acceptedFiles: 'image/*',
		    maxFilesize: 5, // MB
			 init: function() {
				this.on('success', function(file, response) {
					 var responseText = jQuery.parseJSON(response)
				
 var data=\"<tr id='row-\"+responseText.id+\"'><td><a target='_blank' href='".base_url('uploads/gallery')."\"+responseText.url+\"'><img src='".base_url('uploads/gallery/')."\"+responseText.url+\"' width='50px'></a></td><td><input type='text' class='form-control imgtitle' data-id='\"+responseText.title+\"' value=''></td><td><input type='text' class='form-control imgorder' data-id='\"+responseText.id+\"' value='0'></td><td>\"+responseText.updatedon+\"</td><td align='center'><button class='btn  btn-danger mb-2 removeimg' data-id='\"+responseText.id+\"' data-url='\"+responseText.url+\"'> X</button></td></tr>\";
        $('#myimgtb').append(data);					 
				});
			},			
		};
		
		$(document).on('change', '.imgorder', function() {
			var values={};
			values['order'] = $(this).val();
			values['id'] =$(this).data('id');
			$.ajax({
					type: 'POST',
					url: '".base_url('admin/galleryplugin/setorder')."',
					data: values,
					dataType: 'html'
				});
			
		  // Does some stuff and logs the event to the console
		});
		
		$(document).on('change', '.imgtitle', function() {
			var values={};
			values['title'] = $(this).val();
			values['id'] =$(this).data('id');
			$.ajax({
					type: 'POST',
					url: '".base_url('admin/galleryplugin/settitle')."',
					data: values,
					dataType: 'html'
				});
			
		  // Does some stuff and logs the event to the console
		});
		
		$(document).on('click', '.removeimg', function() {
			var values={};
			var rowid = $(this).data('id');
			values['id'] =$(this).data('url');
			$.ajax({
					type: 'POST',
					url: '".base_url('admin/galleryplugin/imagedelete')."',
					data: values,
					dataType: 'html',
					success: function(data){						
							$('table#myimgtb tr#row-'+rowid).remove();
					}
				});
			
		  // Does some stuff and logs the event to the console
		});
	</script>";
		return $js;	   
	}
	
	
	public function render($view, $data = NULL, $head = NULL)
    {
		$head['assetspath']=$footer['assetspath']=$data['assetspath'] = $this->assetspath;
		
		//$head['menuitem'] = $this->menuitem;
		$this->load->view($this->template . '_parts/header', $head);
		$this->load->view($this->template . $view, $data);
        //$this->load->view($this->template . '_parts/footer');
    }

}