<?php

//payload configuration for text template
function airtel_noheader($templateId, $to, $from, $headerVars, $variables, $payload, $headerkey){
    $data = array();
    $data['templateId'] = $templateId;
    $data['to'] = $to;
    $data['from'] = $from;
    $data['message'] = array(
        "headerVars" => $headerVars,
        "variable" => $variables,
        "payload" => $payload
    );
    // echo json_encode($data); 
    airtel_sendWhatsapp($data, $headerkey);
}
//payload configuration for header
function airtel_imageheader($templateId, $to, $from, $headerVars, $variables, $payload, $mediaType, $mediaId, $headerkey){
    $data = array();
    $data['templateId'] = $templateId;
    $data['to'] = $to;
    $data['from'] = $from;
    $data['message'] = array(
        "headerVars" => $headerVars,
        "variables" => $variables,
        "payload" => $payload
    );
    if ($mediaType == 'IMAGE') {
        $data['mediaAttachment'] = array(
            "type" => "IMAGE",
            "id" => $mediaId
        );
    } elseif ($mediaType == 'VIDEO') {
        $data['mediaAttachment'] = array(
            "type" => "VIDEO",
            "id" => $mediaId
        );
    } elseif ($mediaType == 'DOCUMENT') {
        $data['mediaAttachment'] = array(
            "type" => "DOCUMENT",
            "id" => $mediaId
        );
    }
    json_encode($data); 
    airtel_sendWhatsapp_header($data, $headerkey);
}
//payload for callback
function airtel_callback($templateId, $to, $from, $headerVars, $variables, $payload, $notifyURL, $method, $headers, $headerkey)
{
    $data = array();
    $data['templateId'] = $templateId;
    $data['to'] = $to;
    $data['from'] = $from;
    $data['message'] = array(
        "headerVars" => $headerVars,
        "variables" => $variables,
        "payload" => $payload
    );
    $data['callBackUrls'] = array(
        "notifyURL" => $notifyURL,
        "method" => $method,
        "headers" => $headers
    );
    json_encode($data); 
    airtel_sendWhatsapp($data, $headerkey);
}
//send function with different url for media message
function airtel_sendWhatsapp_header($params, $headerkey)
{
    $CI = get_instance();
    
    $url = 'https://iqwhatsapp.airtel.in/gateway/airtel-xchange/basic/whatsapp-manager/v1/template/send/media';
    //$headerkey="value";
		//$headerkey = $airtelheader;

    $curlOptions = array(CURLOPT_RETURNTRANSFER => true);
    $curlOptions[CURLOPT_CUSTOMREQUEST] = 'POST';
    $curlOptions[CURLOPT_URL] = $url;
    $requestHeaders = array(
        'Authorization: ' . $headerkey,
        'Content-Type: application/json',
        'Accept: application/json'
    );

    $curlOptions[CURLOPT_POSTFIELDS] = json_encode($params);
    $curlOptions[CURLOPT_HTTPHEADER] = $requestHeaders;
    $curl = curl_init();
    curl_setopt_array($curl, $curlOptions);
    $response = curl_exec($curl);
    curl_close($curl);

    $rsp = json_decode($response, true);

    $contact = preg_replace("/[^0-9]/", "", $params['to']);
    $contact = substr($contact, 2);

    if ($rsp['status'] == 'processing') {
        $CI->Helper_model->updatemessageresponse($contact, 1, $response);
        return 1;
    } else {
        $CI->Helper_model->updatemessageresponse($contact, 3, $response);
        return 0;
    }
}
//send message for curl without media
function airtel_sendWhatsapp($params, $headerkey)
{
    $CI = get_instance();
    
    $url = 'https://iqwhatsapp.airtel.in/gateway/airtel-xchange/basic/whatsapp-manager/v1/template/send';
    //$headerkey="value";
		//$headerkey = $airtelheader;
    

    $curlOptions = array(CURLOPT_RETURNTRANSFER => true);
    $curlOptions[CURLOPT_CUSTOMREQUEST] = 'POST';
    $curlOptions[CURLOPT_URL] = $url;
    $requestHeaders = array(
        'Authorization: ' . $headerkey,
        'Content-Type: application/json',
        'Accept: application/json'
    );

    $curlOptions[CURLOPT_POSTFIELDS] = json_encode($params);
    $curlOptions[CURLOPT_HTTPHEADER] = $requestHeaders;
    $curl = curl_init();
    curl_setopt_array($curl, $curlOptions);
    $response = curl_exec($curl);
    curl_close($curl);

    $rsp = json_decode($response, true);

    $contact = preg_replace("/[^0-9]/", "", $params['to']);
    $contact = substr($contact, 2);

    if ($rsp['status'] == 'processing') {
        $CI->Helper_model->updatemessageresponse($contact, 1, $response);
        return 1;
    } else {
        $CI->Helper_model->updatemessageresponse($contact, 3, $response);
        return 0;
    }
}


?>
