<?php

if(!defined('BASEPATH')) exit('Hacking Attempt : Get Out of the system ..!');

class Contacts_model extends CI_Model
{
	public function __construct(){
		parent::__construct();
	}
	
	
/*##########################################################*/
/*################ Merchants Group ####################*/
/*##########################################################*/
	
	public function get_contacts_list($status=NULL){
		$this->db->select('contact_list.*,merchant.storename, merchant.accountId');
		if($status>=0){
			$where = array('contact_list.status='=>$status);
			$this->db->where($where);
		}
		$this->db->join('merchant','merchant.merchantId=contact_list.merchantId','left');
		$this->db->order_by('contact_list.updatedon','ASC');
		$query = $this->db->get('contact_list');
		
		return $query->result();
	}
	
	public function get_single_contacts_list($id){
		$this->db->select('*');
		$where = array('listId='=>$id);
		$this->db->where($where);
		$query = $this->db->get('contact_list');		
		return $query->result();
	}
	
	public function delete_contacts_list($id){
		$this->db->where('listId', $id );
		$this->db->delete('contact_list');
	}
	
	public function set_contacts_list($data,$id){
		
		if($id>0)
		{
			$this->db->where('listId', $id);
			$this->db->update('contact_list', $data);	
		}else{			
			$this->db->insert('contact_list', $data);			
			$insert_id = $this->db->insert_id();					
		}		

	}
/*##########################################################*/

/*##########################################################*/
/*################ Merchants ####################*/
/*##########################################################*/

	public function get_contacts($status=NULL){
		$this->db->select('contacts.*,contact_list.title as group,merchant.storename as merchantname');
		if($status>=0){
			$where = array('contacts.status='=>$status);
			$this->db->where($where);
		}
		$this->db->join('contact_list','contact_list.listId=contacts.listId','left');
		$this->db->join('merchant','merchant.merchantId=contacts.merchantId','left');
		$this->db->order_by('contacts.updatedon','ASC');
		$query = $this->db->get('contacts');
		
		return $query->result();
	}
	
	public function get_single_contacts($id){
		$this->db->select('*');
		$where = array('contactId='=>$id);
		$this->db->where($where);
		$query = $this->db->get('contacts');		
		return $query->result();
	}
	
	public function delete_contacts($id){
		$this->db->where('contactId', $id );
		$this->db->delete('contacts');
	}
	
	public function set_contacts($data,$id){
		
		if($id>0)
		{
			$this->db->where('contactId', $id);
			$this->db->update('contacts', $data);	
		}else{			
			$this->db->insert('contacts', $data);			
			$insert_id = $this->db->insert_id();					
		}		

	}
		
/*##########################################################*/	
}

?>