<?php

if(!defined('BASEPATH')) exit('Hacking Attempt : Get Out of the system ..!');

class Merchants_model extends CI_Model
{
	public function __construct(){
		parent::__construct();
	}
	
	
/*##########################################################*/
/*################ Merchants Group ####################*/
/*##########################################################*/
	

	
	public function authchk($param)

	{

		$status=1;
		$this->db->select('*');

		$this->db->from('merchant');
		$this->db->where('authlink', $param);
		$this->db->where('status', $status);
		$query = $this->db->get();
		return $query->num_rows();

	}

	public function merchantData($param)

	{

	$this->db->select('*');
	$this->db->where('authlink', $param);
	$query = $this->db->get('merchant');
	$result = $query->row();
	$this->merchantlogindt($result->merchantId);
	return $result;

	}

	public function merchantlogindt($id)
	{
		$this->db->where('merchantId', $id);
		$this->db->update('merchant', array('lastlogin'=>date('Y-m-d H:i:s')));

	}

	public function get_merchant_group($status=NULL){
		$this->db->select('*');
		if($status>=0){
			$where = array('status='=>$status);
			$this->db->where($where);
		}
		$this->db->order_by('updatedon','ASC');
		$query = $this->db->get('merchant_group');
		
		return $query->result();
	}
	
	public function get_single_merchant_group($id){
		$this->db->select('*');
		$where = array('merchantgroupId='=>$id);
		$this->db->where($where);
		$query = $this->db->get('merchant_group');		
		return $query->result();
	}
	
	public function delete_merchant_group($id){
		$this->db->where('merchantgroupId', $id );
		$this->db->delete('merchant_group');
	}
	
	public function set_merchant_group($data,$id){
		
		if($id>0)
		{
			$this->db->where('merchantgroupId', $id);
			$this->db->update('merchant_group', $data);	
		}else{			
			$this->db->insert('merchant_group', $data);			
			$insert_id = $this->db->insert_id();					
		}		

	}
/*##########################################################*/

/*##########################################################*/
/*################ Merchants ####################*/
/*##########################################################*/

	public function get_merchant($status=NULL){
		$this->db->select('merchant.*,merchant_group.title as group,merchant_credits.credits');
		if($status>=0){
			$where = array('merchant.status='=>$status);
			$this->db->where($where);
		}
		$this->db->join('merchant_group','merchant_group.merchantgroupId=merchant.groupId','left');
		$this->db->join('merchant_credits','merchant.merchantId=merchant_credits.merchantId','LEFT');
		$this->db->order_by('merchant.updatedon','ASC');
		$query = $this->db->get('merchant');
		
		return $query->result();
	}
	
	public function get_single_merchant($id){
		$this->db->select('*');
		$where = array('merchantId='=>$id);
		$this->db->where($where);
		$query = $this->db->get('merchant');		
		return $query->result();
	}
	
	public function delete_merchant($id){
		$this->db->where('merchantId', $id );
		$this->db->delete('merchant');
	}
	
	public function set_merchant($data,$id){
		
		if($id>0)
		{
			$this->db->where('merchantId', $id);
			$this->db->update('merchant', $data);	
		}else{			
			$this->db->insert('merchant', $data);			
			$insert_id = $this->db->insert_id();
			$this->create_credit_account($insert_id);
		}		

	}
	
	public function update_merchant($data){

			$this->db->where('accountId', $data['accountId']);
			$this->db->update('merchant', $data);	
		
	}
	
	public function get_merchant_credits($id){
		$this->db->select('merchant_credits.*,merchant.storename');
		$where = array('merchant_credits.merchantId='=>$id);
		$this->db->join('merchant','merchant.merchantId=merchant_credits.merchantId','LEFT');
		$this->db->where($where);
		$query = $this->db->get('merchant_credits');		
		return $query->result();
	}
	
	public function get_merchant_credits_history($id)
	{
		$this->db->select('*');
		$where = array('merchantId='=>$id);
		$this->db->where($where);
		$this->db->order_by('id','DESC');
		$query = $this->db->get('merchant_credits_history');	
		
		return $query->result();
	}
	
	public function create_credit_account($id)
	{
		$data=array();
		$data['merchantId']=$id;
		$data['credits']='0';
		$data['previous_credits']='0';
		$data['updatedon']=date('Y-m-d H:i:s');
		$data['status']='1';
		$this->db->insert('merchant_credits', $data);
	}
	
	
	public function add_credit_account($id,$data)
	{
		$this->db->select('*');
		$this->db->where('merchantId', $id);
		$query = $this->db->get('merchant_credits');
		$result = $query->result();		
		$previouscredits = $result[0]->credits;		
		$insetcredits = $data['credits'];		
		$newcredits = $previouscredits+$insetcredits;
		
		$updata=array();
		$updata['credits']=$newcredits;
		$updata['previous_credits']=$previouscredits;
		$updata['updatedon']=date('Y-m-d H:i:s');
		$updata['status']='1';
		
		$this->db->where('merchantId', $id);
		$this->db->update('merchant_credits', $updata);	
		
		//$this->db->last_query();
		
		$data['new_credits']=$newcredits;
		$data['previous_credits']=$previouscredits;
		$data['merchantId']=$id;
		$this->update_credit_account_log($data);
		
	}
	
	public function remove_credit_account($id,$data)
	{
		$this->db->select('*');
		$this->db->where('merchantId', $id);
		$query = $this->db->get('merchant_credits');
		$result = $query->result();		
		
		$previouscredits = $result[0]->credits;		
		$removecredits = $data['credits'];		
		$newcredits = $previouscredits-$removecredits;
		
		$updata=array();
		$updata['credits']=$newcredits;
		$updata['previous_credits']=$previouscredits;
		$updata['updatedon']=date('Y-m-d H:i:s');
		$updata['status']='1';
		
		$this->db->where('merchantId', $id);
		$this->db->update('merchant_credits', $updata);	
		
		$data['new_credits']=$newcredits;
		$data['previous_credits']=$previouscredits;
		$data['merchantId']=$id;
		$this->update_credit_account_log($data);
		
	}
	
	public function  update_credit_account_log($data)
	{	
		$this->db->insert('merchant_credits_history', $data);
	}
/*##########################################################*/	
}

?>