# Getting Involved

Thanks for your interest in the project, we'd love to have you involved! Check out the sections below to find out more about what to do next...

## Submitting an Issue

If you've seen something that is or might seem like a bug or a mistake in the documentation, or you simply have a suggestion for a new feature, please go ahead and open us [an issue][issue-link].
Include as much information as you have.

Before you submit your issue please do the archive search first, maybe the same question was already answered or is pending.

If you did not find a related issue among the ones already asked, feel free to open a new issue.

For new feature requests, feel free not to follow to the letter the following structure. However, for any sort of bug, anomaly, issue etc. type of request, please do refer to provided structure. It might save us a lot of time to pinpoint and fix what is the subject of the issue in less time.

### New issue structure (bugs, anomalies, improvements...)
Providing the following information will increase the chances of your issue being dealt with quickly:

* **Short TO-THE-POINT Overview** - what seems to be the issue
* **Description** - more detailed explanation of the issue. The stack trace in cases where it is applicable.
* **Which version(s)** - which library version(s) did you used when occurred with this issue.
* **Environment** - is this a problem with all development/testing/production environments or only specific one(s)?
* **Reproducing** - how did it happen? Is it an isolated anomaly, can you reproduce it, what are the steps to reproduce it?
* **Related Issues** - is there something similar to this issue that has been reported before? If so, please tag that issue(s) as a reference.
* **Suggest a Fix** - this code is generated, but perhaps you can point to the part of the code that might be causing the bug.

## Pull requests disclaimer
We will not be accepting pull requests, however, because source code contained within this repository is **generated**,
hence the changes will need to be made by us within library generation configuration. Having said that, we still fully
do encourage you to submit an issue since that will help us track it and keep you up-to-date.

[issue-link]: https://github.com/infobip/infobip-api-php-client/issues/new
