<?php
defined('BASEPATH') or exit('No direct script access allowed');
require_once('vendor/autoload.php');
use Shopify\Auth\SessionStorage;
use Shopify\Auth\FileSessionStorage;
use Shopify\Auth\Session;
use Shopify\Auth\OAuth;
use Shopify\Auth\OAuthCookie;
use Shopify\Context;

class Shopifyapi extends CI_Controller
{

	public $events;
		
	function __construct()
	{

		parent::__construct();
		$this->load->model('Shopify_model');
		$this->load->library('session');

		$this->events = [
			'order_create' => 'Order Placed',
			'order_fulfilled' => 'Order Fullfiled',
			'order_cancelled' => 'Order Cancelled'
		];

		$this->load->library('shopifywebhook');

		Context::initialize(
			apiKey: SPFKEY,
			apiSecretKey: SPFSECRET,
			scopes: ['read_products','write_products','read_orders','read_locations','write_locations','write_orders','read_draft_orders',' write_draft_orders','read_customers','write_customers','read_checkouts','write_checkouts','read_assigned_fulfillment_orders','write_assigned_fulfillment_orders'],
			hostName: 'https://msg.greenreceipt.in',
			sessionStorage: new FileSessionStorage('./tmp/shopify_api_sessions'),
			apiVersion: '2023-04',
			isEmbeddedApp: true,
			isPrivateApp: false
		);
	}

	public function index($param = null)
	{
		echo "hello";

	}

	/*########################### METHOD TO INSTALL PLUGIN ########################################*/
	public function install()
	{
		$shop = @$_GET['shop'];

		// OAuth::begin(
		// 	"https://buynxtstore.myshopify.com",
		// 	base_url('shopifyapi/auth/1'),
		// 	false
		// );
		// unset($_SESSION['greenreceipt_cookie']);
		// $_SESSION['greenreceipt_cookie']= function (OAuthCookie $cookie) use (&$cookiesSet) {
		// 	$cookiesSet[$cookie->getName()] = $cookie;
			
		// 	return !empty($cookie->getValue());
		// };


		$redirectUrl = OAuth::begin(
			$shop,
		'buybotspf/index.php/shopifyapi/auth/1', // doesn't do anything!
			 false
		);

		 redirect($redirectUrl);
		die;

	}
	/*########################### END ########################################*/


	public function auth($param = 0)
	{
		$host=$_GET['host'];
		$shop = @$_GET['shop'];
		 Context::$SESSION_STORAGE = new FileSessionStorage('tmp/shopify_api_sessions');
		$callback=	OAuth::callback(
			$_COOKIE, 
			 $_GET
		);
		$accesstoken=$callback->getAccessToken(); 
		$data = array();
		$data['accesstoken'] = $accesstoken;
		$data['shop'] = $shop;
		$data['created_on'] = date('Y-m-d H:i:s');
		$data['updated_on'] = date('Y-m-d H:i:s');
		$data['usertoken'] = md5($shop . SPFKEY);
		$data['api'] = $this->buybot_get_token($data['shop']);
		$this->Shopify_model->insertaccesstoken($data);
		$result = $this->Shopify_model->gettokendata($data['usertoken']);
		$accountId = @$result[0]->accountId;
		$api = @$result[0]->api;
		$token = @$result[0]->usertoken;
		
		$this->createaccount($api,$token,$accountId);
		
		if (!empty($callback->getShop())&&($callback->getShop()==$shop)){
		//print_r(base_url('shopifyapi/setup?embedded='.$param.'&token='.$data['usertoken']));exit;
		//redirect("https://76f6-223-190-87-186.ngrok-free.app/index.php/shopifyapi/setup?embedded=1&token=11c2b6e42bed11c0dbebd3e3d9ed70ef");
		redirect(base_url('index.php/shopifyapi/setup?embedded='.$param.'&token='.$data['usertoken'].'&host='.$host));

		}else{
			redirect(base_url('shopifyapi/install'));
		}

	}

	public function setup()
	{
		//print_r($_GET['host']);exit;
		//header("Content-Security-Policy: frame-ancestors https://buynxtstore.myshopify.com https://admin.shopify.com");
		$result = $this->Shopify_model->gettokendata(@$_GET['token']);

		$data = array();
		$data['msg'] = '';
		if (isset($_GET['msg'])) {
			$data['msg'] = '<div class="alert alert-success">Thank You! Your App Data Updated Successfully</div>';
		}
		$accountId = @$result[0]->accountId;
		$token = @$result[0]->usertoken;
		$shop = @$result[0]->shop;
		$api = @$result[0]->api;
		$status = @$result[0]->status;
		$updatedon = @$result[0]->updated_on;

		//header("Content-Security-Policy: frame-ancestors https://".$shop." https://admin.shopify.com;");
		$data['shop'] = $shop;//"https://buynxtstore.myshopify.com";//$shop;
		$data['apikey'] = '123';//$api;
		$data['token'] =$token;//"11c2b6e42bed11c0dbebd3e3d9ed70ef";// $token;
		$data['accountId'] =$accountId;// '96';//$accountId;
		if(isset($_GET['host'])){
			$this->session->set_userdata('host', $this->input->get('host'));

		}
		
		//print_r($_SESSION['host']); exit;
		$data['host'] = $this->session->userdata('host');

		$accountevents = $this->Shopify_model->getaccountevents('96');
		$i = 0;
		$eventdata = array();
		foreach ($accountevents as $ev) {
			$eventdata[$i] = $ev->event;
			$i++;
		}

		$data['accountevents'] = $eventdata;
		$data['events'] = $this->events;
		//print_r($data); exit;

		$this->load->view('shopify/setup', $data);
	}

	/*########################### METHOD TO GENERATE SHOPIFY ACCESS TOKEN ########################################*/

	public function createaccount($apikey,$token,$accountId)
	{
		//print_r($_POST);
		$data = array();
		// $apikey = $_POST['apikey'];
		// $token = $_POST['token'];
		// $accountId = $_POST['accountId'];


		$selectedevents = array();
		$i = 0;
		foreach (@$this->events as $e => $event) {
				$selectedevents[$i] = $e;
				$i++;
		}
		if ($this->checkapikey($apikey)) {
			$this->Shopify_model->updateapikey($token, $apikey);
			$this->checkevents($token, $accountId, $selectedevents);

		} else {
			echo "Wrong API Key Entered";
		}
	}

	public function checkapikey($apikey)
	{
		return 1;
	}

	public function buybot_get_token($store)
	{

		//$url = "https://bestby.co.in/Ecom/WooComerceRegistration";
		$url = "https://api.greenreceipt.in/webhook/shopify/AddMerchant";

		$body = json_encode(array("storename" => $store, "storeurl" => $store));

		$curlOptions = array(CURLOPT_RETURNTRANSFER => TRUE);
		$curlOptions[CURLOPT_CUSTOMREQUEST] = 'POST';
		$curlOptions[CURLOPT_URL] = $url;
		$requestHeaders = array(
			'Content-Type: application/json',
			'Accept: application/json'
		);

		$curlOptions[CURLOPT_POSTFIELDS] = $body;
		$curlOptions[CURLOPT_HTTPHEADER] = $requestHeaders;
		$curl = curl_init();
		curl_setopt_array($curl, $curlOptions);
		$response = curl_exec($curl);
		$response = str_replace('"', '', $response);
		curl_close($curl);


		//return $response;
		return 'NWIyZTIyZWYtNGIxYS00NWZiLWE1NzItMmU3YTVl';	
	}
	/*########################### END ########################################*/


	public function checkevents($usertoken, $accountId, $selectedevents)
	{
		//print_r(count($selectedevents)); exit;


		$accountevents = $this->Shopify_model->getaccountevents($accountId);
		$result = $this->Shopify_model->getaccountaccess($accountId);
		
		$accesstoken = $result[0]->accesstoken;
		$shop = $result[0]->shop;
		header("Content-Security-Policy: frame-ancestors https://" . $shop . " https://admin.shopify.com");
		if (count($accountevents) > 0) {
			foreach ($accountevents as $accevent) {
				$this->shopifywebhook->removewebhook($accesstoken, $shop, @$accevent->eventId);
				$this->Shopify_model->removeaccountevents(@$accevent->eventId);
			}

		}

		if (count($selectedevents) > 0) {
			foreach ($selectedevents as $createevent) {
				$result = $this->shopifywebhook->createwebhook($usertoken, $accesstoken, $shop, $createevent);

				if (@$result['webhook']['id'] > 0) {
					$data = array();
					$data['eventId'] = $result['webhook']['id'];
					$data['event'] = $createevent;
					$data['eventurl'] = $result['webhook']['address'];
					$data['accountId'] = $accountId;
					$data['created_on'] = date('Y-m-d H:i:s');
					$this->Shopify_model->saveaccountevents($data);
				}
			}
			
			
		}
		$allhooks = $this->getallevents($accesstoken, $shop);
		//print_r($allhooks);
		$this->checkab($accesstoken, $shop);

		//redirect(base_url('index.php/shopifyapi/setup?token=' . $usertoken . '&msg=success'));

	}

	public function getallevents($accesstoken, $shop)
	{
		$result = $this->shopifywebhook->allwebhooks($accesstoken, $shop);
		return $result;
		//print_r($result);
	}

	public function checkab()
	{
		$accesstoken = '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';
		$shop = 'buynxtstore.myshopify.com';
		$result = $this->shopifywebhook->getcartab($accesstoken, $shop);
		echo "<pre>";
		//print_r($result);
		echo "</pre>";
	}


}
