<!DOCTYPE html>
<html>

<head>
    <title>Features & Details</title>
    <style>
        .carousel-container {
            position: relative;
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            overflow: hidden;
        }

        .carousel {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }

        .carousel img {
            width: 100%;
            height: auto;
        }

        .carousel-controls {
            text-align: center;
            margin-top: 10px;
        }

        .carousel-controls button {
            background: none;
            border: none;
            cursor: pointer;
            font-size: 20px;
            margin: 0 5px;
        }

        .video-container {
            max-width: 600px;
            margin: 20px auto;
        }

        iframe {
            width: 100%;
            height: 360px;
        }

        .image-row {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

        .image-column {
            flex-basis: 30%;
        }

        .image-column img {
            width: 100%;
            height: auto;
        }

        .image-column p {
            text-align: center;
        }

        /* Additional styles for the new section */
        .about-section {
            text-align: center;
            margin: 40px 0;
        }

        .about-section h2 {
            font-size: 24px;
            color: #333;
            margin-bottom: 20px;
        }

        .feature-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
        }

        .feature-item {
            flex-basis: calc(33.33% - 20px);
            margin: 10px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
            text-align: center;
            transition: transform 0.3s ease-in-out;
        }

        .feature-item:hover {
            transform: scale(1.05);
        }

        .feature-item h3 {
            font-size: 18px;
            margin-top: 10px;
        }

        .feature-item p {
            color: #666;
        }

        .main {
            padding: 0 110px !important;
        }

        .row1 {
            padding: 25px 0;
        }

        .center {
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
</head>
</head>

<body>

    <div class="about-section">
        <img src="./uploads/gr_logo.png" alt="Image 2" width="150">
        <div class="container main">
            <h2> <img src="./uploads/picture0.png" alt="Image 2" width="900" height="200">
            </h2>
            <p>Say hello to automatic onboarding on the ONDC seller network, for online sales!
                Seamlessly join Open Network for Digital Commerce (ONDC) with existing shopify account.
                Boost online sales on popular Buyer Apps (PayTM, PhonePe etc.) sans high commissions. In
                addition, launch DTC channel on WhatsApp to nudge repeat purchase. Effortless, all-in-one
                solution in a single plug-in!</p>
            <a href="https://buynxt.in/" target="_blank" class="btn btn-success">Know More</a>
            <hr>
        </div>
    </div>


    <div class="container main">
        <div class="row row1">
            <div class="col-md-7">
                <h2>Effortless ONDC Seller Onboarding</h2>
                <p>Integrate effortlessly with the Open Network for Digital Commerce (ONDC) using
                    a single plug-in on existing Shopify account. Boost digital sales, avoid high
                    e-commerce fees. List products seamlessly across popular ONDC Buyer Apps like PayTM,
                    PhonePe, Ola, and receive & manage orders within your Shopify account. Elevate your commerce journey
                    with easy onboarding.

                </p>
            </div>
            <div class="col-md-5">
                <img src="./uploads/picture3.png" alt="Image 2" style="height: 170px;">
            </div>
        </div>
        <div class="row row1">
            <div class="col-md-5">
                <img src="./uploads/picture1.png" alt="Image 2" style="height: 185px;">
            </div>
            <div class="col-md-7">
                <h2>Launch your WhatsApp Store! </h2>
                <p>Create a seamless end-to-end commerce experience on WhatsApp using WhatsApp Store. Enjoy limitless
                    cataloguing possibilities, integrated payment options, all presented through an intuitive user
                    interface. Stimulate repeat purchases with personalized nudges and thoughtfully curated
                    catalogues—all effortlessly accessible within the WhatsApp interface. Don't miss out on the
                    opportunity to enhance your direct-to-consumer journey. Get started now!</p>
            </div>
        </div>

        <hr>
    </div>

    <!-- Features section -->
    <div class="container main">
        <h2>App Major Highlight Features</h2>
        <div class="feature-list">
            <div class="feature-item">
                <i class="fas fa-check-circle fa-3x"></i>
                <h3>Feature 1</h3>
                <p>Publish & maintain your existing assortment on Shopify onto ONDC and get automatically listed as
                    seller on all Buyer Apps on ONDC.</p>
            </div>
            <div class="feature-item">
                <i class="fas fa-calendar-alt fa-3x"></i>
                <h3>Feature 2</h3>
                <p>Receive & process orders from popular BuyerApp (PayTM, PinCode etc) within your existing Shopify
                    order dashboard.</p>
            </div>
            <div class="feature-item">
                <i class="fas fa-envelope fa-3x"></i>
                <h3>Feature 3</h3>
                <p>Notify order status. Directly to shoppers on WhatsApp and enable Pay & Shop features within WhatsApp
                    interface for repeat shopping.at zero commissions.</p>
            </div>
        </div>
        <hr>
    </div>

    <div class="container main">
        <h2>Web Notification Message on Whatsapp to Your Customer</h2>
        <div class="image-row">
            <div class="image-column">
                <p><b>ORDER PLACED</b></p>
                <img src="./uploads/picture2.png" alt="Image 2">
            </div>
            <div class="image-column">
                <p><b>ORDER CANCEL</b></p>
                <img src="./uploads/picture2.png" alt="Image 2">
            </div>
            <div class="image-column">
                <p><b>ORDER FULFILLED</b></p>
                <img src="./uploads/picture2.png" alt="Image 2">
            </div>
        </div>
        <hr>
    </div>

    <div class="container main">
        <h2>Order Place Journey on Your Store</h2>
        <div class="video-container">
            <video width="560" height="315" controls>
                <source src="./uploads/orderplace.mp4" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
        <hr>
    </div>


    <div class="container main">
        <h2>Green Receipt WhatsApp Commerce App Install & Uninstall and Select Web Notification in Store Account
        </h2>

        <!-- <div class="video-container">
    <iframe width="560" height="315" src="https://www.youtube.com/embed/ZRwQDJPVwqI" frameborder="0" allowfullscreen></iframe>
    </div> -->
        <div class="video-container">
            <video width="560" height="315" controls>
                <source src="./uploads/shopifyappinstall (2).mp4" type="video/mp4">
                Your browser does not support the video tag.
            </video>


        </div>
    </div>


    <div class="container main">
        <h2>Note: </h2>
        <p>After downloading the plug-in, you will receive an email requesting additional information needed to register
            you as a seller on ONDC. Subsequently, your product assortment will seamlessly appear on BuyerApp.
            Additionally, any changes in inventory prices made on your Shopify account will automatically reflect on
            ONDC.
            When customers place orders on BuyerApp platforms like PayTM, these orders will be visible in your Shopify
            order dashboard. Simultaneously, notifications will be sent to your store staff via WhatsApp. Any actions
            taken on the orders at the store's end will also trigger notifications to customers via WhatsApp.
            The plug-in facilitates notifications from your existing website for various events such as order placement,
            cancellation, abandoned cart, and checkout. These notifications, including prompts for shopping again and
            making payments, are sent to customers on WhatsApp to encourage repeat shopping. For further details,
            contact <a href="mailto:support@buynxt.in">support@buynxt.in</a> or reach out via WhatsApp at <a href="https://tinyurl.com/2x78yhen" target="_blank">GreenReceipt</a> . 
            Visit <a href="www.buynxt.in" target="_blank"> www.buynxt.in</a> 
            for FAQs.
        </p>

        <hr>
    </div>

    <div class="container main">
        <h2>Why choose BuyNxt / Green Receipt as Seller Marketplace?</h2>
        <p>
            <li> Easy Integration: Simple plug-in for onboarding via existing POS or website.</li>
            <li> Commission Savings: No per-order commissions, enhancing profitability.</li>
            <li>Channel Visibility: We share order wise exact status, commissions charged by each entity, on-network &
                off-network logistics tracking, and payment settlement.</li>
            <li>Order Management & Rerouting System: Receive orders on current POS and staff WhatsApp, in preferred
                language. Streamlined operations and multilingual support, ensures reduce TAT, better fulfilment &
                ratings
                on the network.</li>
        </p>
        <div class=" about-section">
            <div class="col-md-12">
                <img src="./uploads/qr_code.jpeg" alt="Image 2" width="150" height="150">
            </div>
            <p class="btn btn-danger">Scan To Connect</p>

        </div>
        <div class="col-md-12" style="padding-bottom:50px">
            <img src="./uploads/picture4.png" alt="Image 2" width="900" height="100" class="center">
        </div>
    </div>


</body>

</html>