<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Shopifywebhook {

	public $events;
	public $accesstoken;
	public $shop;

	// orders/cancelled, orders/create, orders/fulfilled, orders/paid, orders/partially_fulfilled, orders/updated
	function __construct(){	

		$this->events=['cust_registration'=>'customers/create',
		'order_create'=>'orders/create',
		'order_fulfilled'=>'orders/fulfilled',
		'order_cancelled'=>'orders/cancelled'];
		
		$this->accesstoken=@$_SESSION['accesstoken'];
		$this->shop=@$_SESSION['shop'];
	}

public function index($param=null)
	{
		
	}
	
	
public function removewebhook($accesstoken,$shop,$id)
{
	$param=array();
	$result = $this->performShopifyRequest($accesstoken,$shop,'webhooks/'.$id, $param, 'DELETE');
	return $result;
}

public function createwebhook($usertoken,$accesstoken,$shop,$e)
{
	if($e == 'cust_registration'){
	
	$param['webhook']= array("topic"=>$this->events[$e],"address"=>base_url('Shopifyhandler/cust/'.$e.'/'.$usertoken),"format"=>"json");
	
	}else{
		$param['webhook']=array("topic"=>$this->events[$e],"address"=>base_url('Shopifyhandler/order/'.$e.'/'.$usertoken),"format"=>"json");
		
	}
	
	
	json_encode($param);
	$result = $this->performShopifyRequest($accesstoken,$shop,'webhooks', $param, 'POST');
	return $result;
}

public function allwebhooks($accesstoken,$shop)
{
	$param=array();
	$result = $this->performShopifyRequest($accesstoken,$shop,'webhooks', $param, 'GET');
	return $result;
}

public function getcartab($accesstoken,$shop)
{
	$param=array();
	$result = $this->performShopifyRequest($accesstoken,$shop,'checkouts', array('abandoned'=>true,'created_at_max'=>date('c',strtotime("-30 minutes"))), 'GET');
	return $result;
}

//function for gettting products details
public function getproducts($accesstoken,$shop)
{
	$result = $this->performShopifyRequest($accesstoken,$shop,'products', array(), 'GET');
	return $result;
}

// public function getproducts($accesstoken, $shop, $limit = 250, $page = 1)
// {
//     $params = array(
//         'limit' => $limit,
//         'page' => $page
//     );
//     $result = $this->performShopifyRequest($accesstoken, $shop, 'products', $params, 'GET');
//     return $result;
// }

//function for getting shop details
public function getshop($accesstoken,$shop)
{
	$result = $this->performShopifyRequest($accesstoken,$shop,'shop', array(), 'GET');
	return $result;
}

function performShopifyRequest($accesstoken,$shop,$resource, $params = array(), $method = 'GET') {

	$shop =  $shop;
	$token = $accesstoken ;
	$url = "https://{$shop}/admin/{$resource}.json";

  $curlOptions = array(
    CURLOPT_RETURNTRANSFER => TRUE
  );

  if ($method == 'GET') {
    if (!is_null($params)) {
      $url = $url . "?" . http_build_query($params);
    }
  } else {
    $curlOptions[CURLOPT_CUSTOMREQUEST] = $method;
  }

  $curlOptions[CURLOPT_URL] = $url;

  $requestHeaders = array(
    "X-Shopify-Access-Token: {$token}",
    "Accept: application/json"
  );

  if ($method == 'POST' || $method == 'PUT') {
    $requestHeaders[] = "Content-Type: application/json";

    if (!is_null($params)) {
      $curlOptions[CURLOPT_POSTFIELDS] = json_encode($params);
    }
  }

  $curlOptions[CURLOPT_HTTPHEADER] = $requestHeaders;

  $curl = curl_init();
  curl_setopt_array($curl, $curlOptions);
  $response = curl_exec($curl);
  curl_close($curl);
	
	//print_r($response);
 return json_decode($response, TRUE);
}
	
}
