<?php
defined('BASEPATH') OR exit('No direct script access allowed');

//require_once '.../errorHandler.php';

class Shopifywebhook extends CI_Controller {

	public $events;
	
	function __construct(){

		parent::__construct();
		$this->load->model('Shopify_model'); 		
		$this->events=['cust_registration'=>'Customer Registration',
		'order_processing'=>'Order Placed',
		'order_fail'=>'Order Failed',
		'order_completed'=>'Order Delivered',
		'order_cancelled'=>'Order Cancelled',
		'order_pending'=>'Order Pending',
		'order_hold'=>'Order Hold',
		'order_refund'=>'Order Refund'];

		
		 require('Shopifywebhook.php');
		 $webhook = new Shopifywebhook();
		
	}

public function index($param=null)
	{
		echo "hello";
	}
	
public function sayhello($param=null)
	{
		echo "hello";
	}	

/*########################### METHOD TO INSTALL PLUGIN ########################################*/	
public function install()
	{
		$shop = @$_GET['shop'];
		$api_key = SPFKEY;
		$scopes = "read_orders,read_products";
		$redirect_uri = base_url('shopifyapi/setup');
		$install_url = "https://" . $shop . "/admin/oauth/authorize?client_id=" . $api_key . "&scope=" . $scopes . "&redirect_uri=" . urlencode($redirect_uri);
		redirect($install_url);
		die();
	}
/*########################### END ########################################*/

public function setup(){
		$data=array();
		if(isset($_GET['hmac']) && $_GET['hmac'] !=null){
			$this->getaccesstoken();	
		}		
		$result = $this->Shopify_model->gettokendata(@$_SESSION['access_token']);
		
		$_SESSION['accountId'] = $result[0]->accountId;
		$shop=$result[0]->shop;
		$accesstoken=$result[0]->accesstoken;
		$api=$result[0]->api;
		$status=$result[0]->status;
		$updatedon=$result[0]->updated_on;
		
		$data['shop']=$shop;
		$data['apikey']=$api;
		
		$accountevents = $this->Shopify_model->getaccountevents($_SESSION['accountId']);
		$data['accountevents']=$accountevents;
		
		$data['events']=$this->events;
		
		$this->load->view('shopify/setup',$data);
}	

/*########################### METHOD TO GENERATE SHOPIFY ACCESS TOKEN ########################################*/	

public function createaccount(){
	$data=array();
	$accountId=$_SESSION['accountId'];
	$apikey=$_POST['apikey'];
	
	$selectedevents=array();
	$i=0;
	foreach(@$this->events as $e=>$event){if(isset($_POST[$e])){ $selectedevents[$i]=$e; $i++;}}

	if($this->checkapikey($apikey)){
			$this->checkevents($selectedevents);	
	}else{
		echo "Wrong API Key Entered";
	}
	
	

}

public function checkapikey($apikey){
	return 1;
}

public function getaccesstoken(){
	if(!isset($_SESSION['access_token']) && @$_SESSION['access_token'] ==null ){
		$params = $_GET; // Retrieve all request parameters
		$hmac = $_GET['hmac']; // Retrieve HMAC request parameter

		$params = array_diff_key($params, array('hmac' => '')); // Remove hmac from params
		ksort($params); // Sort params lexographically
		$computed_hmac = hash_hmac('sha256', http_build_query($params), SPFSECRET);
		// Use hmac data to check that the response is from Shopify or not
		if (hash_equals($hmac, $computed_hmac)) {

			// Set variables for our request
			$query = array(
				"client_id" => SPFKEY, // Your API key
				"client_secret" => SPFSECRET, // Your app credentials (secret key)
				"code" => $params['code'] // Grab the access key from the URL
			);

			// Generate access token URL
			 $access_token_url = "https://" . $params['shop'] . "/admin/oauth/access_token";

			// Configure curl client and execute request
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_URL, $access_token_url);
			curl_setopt($ch, CURLOPT_POST, count($query));
			curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($query));
			$result = curl_exec($ch);
			curl_close($ch);
			// Store the access token
			$result = json_decode($result, true);

			$access_token = $result['access_token'];

			// Show the access token (don't do this in production!)
			//echo $params['shop'];
			$data=array();
			$data['accesstoken']=$access_token;
			$data['shop']=@$params['shop'];
			$data['status']=1;
			$data['created_on']=date('Y-m-d H:i:s');
			$this->Shopify_model->insertaccesstoken($data);
			$_SESSION['access_token']=$access_token;
		}	

	}

}
/*########################### END ########################################*/

public function shopifyrequest($shop, $token, $resource, $params = array(), $method = 'GET'){
		//$url = "https://{$shop}/admin/{$resource}.json";
		$url ="https://{$shop}/admin/api/2023-07/{$resource}.json"

		  $curlOptions = array(
			CURLOPT_RETURNTRANSFER => TRUE
		  );

		  if ($method == 'GET') {
			if (!is_null($params)) {
			  $url = $url . "?" . http_build_query($params);
			}
		  } else {
			$curlOptions[CURLOPT_CUSTOMREQUEST] = $method;
		  }

		  $curlOptions[CURLOPT_URL] = $url;
		  $requestHeaders = array(
			"X-Shopify-Access-Token: ${token}",
			"Accept: application/json"
		  );
		  if ($method == 'POST' || $method == 'PUT') {
			$requestHeaders[] = "Content-Type: application/json";

			if (!is_null($params)) {
			  $curlOptions[CURLOPT_POSTFIELDS] = json_encode($params);
			}
		  }
		  $curlOptions[CURLOPT_HTTPHEADER] = $requestHeaders;
		  $curl = curl_init();
		  curl_setopt_array($curl, $curlOptions);
		  $response = curl_exec($curl);
		  curl_close($curl);

		  return json_decode($response, TRUE);
}

public function checkevents($selectedevents){
	print_r($selectedevents);
	$accountId = @$_SESSION['accountId'];
	// $accountId = '96';
	
	$accountevents = $this->Shopify_model->getaccountevents($accountId);
	if(count($accountevents)>0){
		foreach($accountevents as $accevent ){
			// print_r($accevent);
			
		}
	}
}

}
