<!DOCTYPE html>
<html>
<head>
    <title>ONDC Order Details</title>
   
    <style>
        th {
            cursor: pointer;
        }
    </style>
</head>
<body>
    <h2>ONDC Orders</h2>
    <table border="1" id="orderTable">
        <thead>
            <tr>
                <th><a href="?sort=<?php echo $sort_direction === 'asc' ? 'desc' : 'asc'; ?>">Order No</a></th>
                <th>Status</th>
                <th><a href="?sort=<?php echo $sort_direction === 'asc' ? 'desc' : 'asc'; ?>">Date</a></th>
                <th>Total Price</th>
                <th>Customer Name</th>
                <th>Mobile No</th>
                <th>Last Action</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $order_data = file_get_contents('ondcorder.json');
                $orders = json_decode($order_data, true);

                // Determine the sort direction
                $sort_direction = isset($_GET['sort']) && $_GET['sort'] === 'desc' ? 'desc' : 'asc';

                if ($orders) {
                    // Sort the $orders array based on the selected column and sort direction
                    $column_to_sort = isset($_GET['sort']) && $_GET['sort'] === 'desc' ? 'date' : 'orderno';
                    usort($orders, function ($a, $b) use ($column_to_sort, $sort_direction) {
                        return $sort_direction === 'asc' ? strcmp($a[$column_to_sort], $b[$column_to_sort]) : strcmp($b[$column_to_sort], $a[$column_to_sort]);
                    });

                    foreach ($orders as $order) {
                        $orderno = $order['orderno'];
                        $status = $order['status'];
                        $date = $order['date'];
                        $totalprice = $order['totalprice'];
                        $customername = $order['customername'];
                        $mobileno = $order['mobileno'];
            ?>
            <tr>
                <td><?php echo $orderno; ?></td>
                <td><?php echo $status; ?></td>
                <td><?php echo $date; ?></td>
                <td><?php echo $totalprice; ?></td>
                <td><?php echo $customername; ?></td>
                <td><?php echo $mobileno; ?></td>
                <td>
                    <a href="https://msg.greenreceipt.in/buybotspf/order_details.php?orderno=<?php echo $orderno; ?>">Order Process</a>
                </td>
            </tr>
            <?php
                    }
                } else {
                    echo "<tr><td colspan='7'>No orders found.</td></tr>";
                }
            ?>
        </tbody>
    </table>

    <script>
        // Function to sort the table data
        function sortTable(n) {
            var table, rows, switching, i, x, y, shouldSwitch, dir, switchcount = 0;
            table = document.getElementById("orderTable");
            switching = true;
            // Set the sorting direction to ascending
            dir = "asc";
            while (switching) {
                switching = false;
                rows = table.rows;
                for (i = 1; i < (rows.length - 1); i++) {
                    shouldSwitch = false;
                    x = rows[i].getElementsByTagName("TD")[n];
                    y = rows[i + 1].getElementsByTagName("TD")[n];
                    if (dir == "asc") {
                        if (x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
                            shouldSwitch = true;
                            break;
                        }
                    } else if (dir == "desc") {
                        if (x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) {
                            shouldSwitch = true;
                            break;
                        }
                    }
                }
                if (shouldSwitch) {
                    rows[i].parentNode.insertBefore(rows[i + 1], rows[i]);
                    switching = true;
                    switchcount++;
                } else {
                    if (switchcount == 0 && dir == "asc") {
                        dir = "desc";
                        switching = true;
                    }
                }
            }
        }


        var headers = document.getElementsByTagName("th");
        for (var i = 0; i < headers.length; i++) {
            headers[i].addEventListener("click", function () {
                var index = Array.prototype.indexOf.call(this.parentNode.children, this);
                sortTable(index);
            });
        }
    </script>
</body>
</html>



