<!DOCTYPE html>
<html>
<head>
    <title>Features & Details</title>
    <style>
        .carousel-container {
            position: relative;
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            overflow: hidden;
        }

        .carousel {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }

        .carousel img {
            width: 100%;
            height: auto;
        }

        .carousel-controls {
            text-align: center;
            margin-top: 10px;
        }

        .carousel-controls button {
            background: none;
            border: none;
            cursor: pointer;
            font-size: 20px;
            margin: 0 5px;
        }

        .video-container {
            max-width: 600px;
            margin: 20px auto;
        }

        iframe {
            width: 100%;
            height: 360px;
        }

        .image-row {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

        .image-column {
            flex-basis: 30%;
        }

        .image-column img {
            width: 100%;
            height: auto;
        }

        .image-column p {
            text-align: center;
        }

         /* Additional styles for the new section */
         .about-section {
            text-align: center;
            margin: 40px 0;
        }

        .about-section h2 {
            font-size: 24px;
            color: #333;
            margin-bottom: 20px;
        }

        .feature-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
        }

        .feature-item {
            flex-basis: calc(33.33% - 20px);
            margin: 10px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
            text-align: center;
            transition: transform 0.3s ease-in-out;
        }

        .feature-item:hover {
            transform: scale(1.05);
        }

        .feature-item h3 {
            font-size: 18px;
            margin-top: 10px;
        }

        .feature-item p {
            color: #666;
        }

    </style>
     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
</head>
<body>

<div class="about-section">
    <h2><b>Green Receipt _ ONDC Plug-in</b></h2>
    <p>Say hello to automatic onboarding on the ONDC seller network, for online sales!
Seamlessly join Open Network for Digital Commerce (ONDC) with existing shopify account.
Boost online sales on popular Buyer Apps (PayTM, PhonePe etc.) sans high commissions. In
addition, launch DTC channel on WhatsApp to nudge repeat purchase. Effortless, all-in-one
solution in a single plug-in!</p>
</div>

<!-- Features section -->
<h2>App Major Highlight Features</h2>
<div class="feature-list">
    <div class="feature-item">
        <i class="fas fa-check-circle fa-3x"></i>
        <h3>Feature 1</h3>
        <p>Publish &amp; maintain your existing assortment on Shopify onto ONDC and get automatically
listed as seller on all Buyer Apps on ONDC.</p>
    </div>
    <div class="feature-item">
        <i class="fas fa-calendar-alt fa-3x"></i>
        <h3>Feature 2</h3>
        <p>Receive &amp; process orders from popular BuyerApp (PayTM, PinCode etc) within your existing
Shopify order dashboard.</p>
    </div>
    <div class="feature-item">
        <i class="fas fa-envelope fa-3x"></i>
        <h3>Feature 3</h3>
        <p>Notify order status. Directly to shoppers on WhatsApp and enable Pay &amp; Shop features
within WhatsApp interface for repeat shopping.at zero commissions.</p>
    </div>
</div>

        <h1> <u>Web Notification Message on Whatsapp to Your Customer </u></h1>


        <!-- <h2>Row 1</h2> -->
<div class="image-row">
    <div class="image-column">
        <p><b>ORDER PLACED</b></p> 
        <img src="./uploads/orderplace.jpeg" alt="Image 1" width="200" height="200">
        
    </div>
    <div class="image-column">
        <p><b>ORDER CANCEL</b></p>
        <img src="./uploads/ordercancel.jpeg" alt="Image 2" width="200" height="200">
       
    </div>
    <div class="image-column">
       <p><b>ORDER FULFILLED</b></p>
        <img src="./uploads/ordercomplete.jpeg" alt="Image 3" width="200" height="200">
        
    </div>
</div>

<div class="image-row">
    <div class="image-column">
        <p><b>ABANDONED CHECKOUT</b></p>
        <img src="./uploads/orderabandoned.jpeg" alt="Image 4" width="200" height="200">
       
    </div>
    <!-- <div class="image-column">
        <img src="./uploads/dummySS.jpeg" alt="Image 5">
        <p><b>Order Invoice</b></p>
    </div> -->
    <!-- <div class="image-column">
        <img src="./uploads/dummySS.jpeg" alt="Image 6">
        <p><b>Text for Image 6</b></p>
    </div> -->
</div>

<h1><u>Order Place Journey on Your Store</u></h1>

<div class="video-container">
    <video width="560" height="315" controls>
        <source src="./uploads/orderplace.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
  

</div>

<h2>Note: </h2><p>Post plug-in download, you'll get an email seeking some additional information which is required to register you
as seller on ONDC. Post which your assortment will automatically reflect on BuyerApp s. Further any inventory
price changes done on your shopify account will also be reflected on ONDC automatically.<br><br>
When shoppers place orders on BuyerApp (e.g., PayTM), these orders will reflect in your shopify order dashboard
and in parallel also notification is sent to stores staff on WhatsApp. Any action on the order at store end is further
notified to customers on WhatsApp.<br>
The Plug-in also allows notifications from your existing website for events such as order placed, cancel,
abandoned cart, checkout etc. These notifications are sent to customers on WhatsApp along with shop again &amp;
payments buttons for repeat shopping. For more information write to support@buynxt.in or WhatsApp on
https://tinyurl.com/2x78yhen    Visit for FAQ’s on www.buynxt.in</p>

<h1><u>Green Receipt WhatsApp Commerce App Install & Uninstall and Select Web Notification in Store Account<u></h1>

<!-- <div class="video-container">
    <iframe width="560" height="315" src="https://www.youtube.com/embed/ZRwQDJPVwqI" frameborder="0" allowfullscreen></iframe>
</div> -->
<div class="video-container">
    <video width="560" height="315" controls>
        <source src="./uploads/shopifyappinstall (2).mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>
  

</div>


  <h1> Demo Store & Instructions </h1>
  
    <p><b>Demo Store Url:</b> https://buynxtstore.myshopify.com/</p>
    <p><b>Demo Store Password:</b> demo </p>
    <p><b>Note:</b> Find the demo store credentials above, and just place the order, you will receive the WhatsApp notifications, after placing order. </p>
    <p><b>Testing Payment detail:</b> <br><b>Card Number:</b> Enter '1' for successful transcation, Enter '2' for failed transcation.<br>
    <b>Name of Card:</b> Bogus Gateway <br> <b>CVV:</b> Any 3 digit number (Eg: 111) <br> <b>Expiry Date:</b> Enter any date in future </p>
 




</body>
</html>
