
<?php
echo 'hi';
require 'vendor/autoload.php'; 
require 'guzzle-7.7/src/Client.php';


$api_key = 'YOUR_API_KEY';
$shop = 'your-shop.myshopify.com';
$access_token = 'YOUR_ACCESS_TOKEN';


$order_data = array(
    'line_items' => array(
        array(
            'title' => 'Product Title',
            'price' => '9.99',
            'quantity' => 1,
            'sku' => 'PRODUCT_SKU',
        ),
    ),
    'customer' => array(
        'first_name' => 'John',
        'last_name' => 'Doe',
        'email' => 'john.doe@example.com',
    ),
);

$client = new \GuzzleHttp\Client();

try {
    $response = $client->post("https://$shop/admin/api/2021-04/orders.json", [
        'headers' => [
            'X-Shopify-Access-Token' => $access_token,
            'Content-Type' => 'application/json',
        ],
        'json' => ['order' => $order_data],
    ]);

    // Check for successful response (status code 201)
    if ($response->getStatusCode() === 201) {
        echo "Order created successfully.";
    } else {
        echo "Failed to create order.";
    }
} catch (\GuzzleHttp\Exception\ClientException $e) {
    echo "Error: " . $e->getMessage();
}
