<!DOCTYPE html>
<html>

<head>
    <title>Features & Details</title>
    <style>
        .carousel-container {
            position: relative;
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            overflow: hidden;
        }

        .carousel {
            display: flex;
            transition: transform 0.5s ease-in-out;
        }

        .carousel img {
            width: 100%;
            height: auto;
        }

        .carousel-controls {
            text-align: center;
            margin-top: 10px;
        }

        .carousel-controls button {
            background: none;
            border: none;
            cursor: pointer;
            font-size: 20px;
            margin: 0 5px;
        }

        .video-container {
            max-width: 600px;
            margin: 20px auto;
        }

        iframe {
            width: 100%;
            height: 360px;
        }

        .image-row {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }

        .image-column {
            flex-basis: 30%;
        }

        .image-column img {
            width: 100%;
            height: auto;
        }

        .image-column p {
            text-align: center;
        }

        /* Additional styles for the new section */
        .about-section {
            text-align: center;
            margin: 40px 0;
        }

        .about-section h2 {
            font-size: 24px;
            color: #333;
            margin-bottom: 20px;
        }

        .feature-list {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-around;
        }

        .feature-item {
            flex-basis: calc(33.33% - 20px);
            margin: 10px;
            padding: 20px;
            border: 1px solid #ccc;
            border-radius: 5px;
            text-align: center;
            transition: transform 0.3s ease-in-out;
        }

        .feature-item:hover {
            transform: scale(1.05);
        }

        .feature-item h3 {
            font-size: 18px;
            margin-top: 10px;
        }

        .feature-item p {
            color: #666;
        }

        .main {
            padding: 0 110px !important;
        }

        .row1 {
            padding: 25px 0;
        }

        .center {
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
</head>
</head>

<body>

    <div class="container main">
        <h2>Updated: Order Placed, Cancelled and Abandoned Cart on shopify ShopifyAppPreviewStore dashboard</h2>

        <!-- <div class="video-container">
    <iframe width="560" height="315" src="https://www.youtube.com/embed/ZRwQDJPVwqI" frameborder="0" allowfullscreen></iframe>
    </div> -->
        <div class="video-container">
            <!-- <img src="./uploads/install.png" alt="Image 2" width="560" height="315" controls> -->

            <video width="90%" height="50%" controls>
                <source src="./uploads/shopify_store_order.mp4" type="video/mp4">
                Your browser does not support the video tag.
            </video>


        </div>
        <hr>
    </div>
    <div class="container main">
        <h2>Updated: Whatsapp Notification for Order Placed, Cancelled and Abandoned Cart</h2>

        <!-- <div class="video-container">
    <iframe width="560" height="315" src="https://www.youtube.com/embed/ZRwQDJPVwqI" frameborder="0" allowfullscreen></iframe>
    </div> -->
        <div class="video-container">
            <!-- <img src="./uploads/install.png" alt="Image 2" width="560" height="315" controls> -->

            <video width="90%" height="250px" controls>
                <source src="./uploads/notification_Customer_shopify.mp4" type="video/mp4">
                Your browser does not support the video tag.
            </video>
        </div>
        <h4>Note: Whatsapp Notification video is parallel to the above video(Order Placed, Cancelled and Abandoned Cart on shopify), 1st notifications will popup at 0:37 seconds after order placed successfully.</h4>
        <hr>
    </div>
    <div class="container main">
        <h2>For Reference: ONDC Order Flow On Shopify</h2>

        <!-- <div class="video-container">
    <iframe width="560" height="315" src="https://www.youtube.com/embed/ZRwQDJPVwqI" frameborder="0" allowfullscreen></iframe>
    </div> -->
        <div class="video-container">
            <!-- <img src="./uploads/install.png" alt="Image 2" width="560" height="315" controls> -->

            <video width="90%" height="250px" controls>
                <source src="./uploads/OrderFlowOnShopify.mp4" type="video/mp4">
                Your browser does not support the video tag.
            </video>


        </div>
       
    </div>


</body>

</html>