<?php
/**
 * Template part for displaying the campaign bar
 *
 * @package Goya
 */

$cookie = isset($_COOKIE['et-global-campaign']) ? wp_unslash($_COOKIE['et-global-campaign']) : false;
$dismissible = (goya_meta_config('','campaign_bar_dismissible',true) == true) ? 'dismissible' : '';

$campaigns = get_theme_mod( 'campaign_bar_items', array() );
$layout = get_theme_mod( 'campaign_layout', 'slider' );
$link_mode = get_theme_mod( 'campaign_links_mode', 'button' );

if ( !$cookie ) {
?>
	<aside class="campaign-bar et-global-campaign">
		<div class="container">
			<?php if (sizeof($campaigns) > 1 && $layout == 'slider') { ?>
				<div class="campaign-inner slick" data-autoplay="true">
			<?php } else { ?>
				<div class="campaign-inner inline">
			<?php } ?>
				
				<?php foreach ($campaigns as $campaign) {
					$text = wp_kses( $campaign['campaign_text'], 'essentials' ); ?>

					<?php if (!empty($text)) { ?>
					<div class="et-campaign">
					<?php if(!empty($campaign['campaign_link']) && $link_mode != 'button') { ?>
						<a href="<?php echo esc_url($campaign['campaign_link']); ?>" class="link-<?php echo esc_attr($link_mode); ?>"><?php echo do_shortcode( wp_kses( $campaign['campaign_text'], 'essentials' ) ); ?></a>
					<?php } else { ?>
						<?php echo do_shortcode( wp_kses( $campaign['campaign_text'], 'essentials' ) ); ?>
						<?php if(!empty($campaign['campaign_link']) && $link_mode == 'button') { ?>
							<a href="<?php echo esc_url($campaign['campaign_link']); ?>" class="link-<?php echo esc_attr($link_mode); ?>"><?php echo esc_html($campaign['campaign_button']); ?></a>
						<?php } ?>
					<?php } ?>
					</div>
					<?php } ?>
				<?php } ?>

				<?php 
				if (sizeof($campaigns) < 1) {
					echo do_shortcode( wp_kses( get_theme_mod('campaign_bar_content', ''), 'essentials' ) );	
				}
				 ?>
			</div>
			<button class="et-close <?php echo esc_attr( $dismissible ); ?>"></button>
		</div>
	</aside>
<?php } ?>