<?php
/**
 * TfaStartAuthenticationResponse
 *
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Model;

use \ArrayAccess;
use \Infobip\ObjectSerializer;

/**
 * TfaStartAuthenticationResponse Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class TfaStartAuthenticationResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'TfaStartAuthenticationResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'callStatus' => 'string',
        'ncStatus' => 'string',
        'pinId' => 'string',
        'smsStatus' => 'string',
        'to' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'callStatus' => null,
        'ncStatus' => null,
        'pinId' => null,
        'smsStatus' => null,
        'to' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'callStatus' => 'callStatus',
        'ncStatus' => 'ncStatus',
        'pinId' => 'pinId',
        'smsStatus' => 'smsStatus',
        'to' => 'to'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'callStatus' => 'setCallStatus',
        'ncStatus' => 'setNcStatus',
        'pinId' => 'setPinId',
        'smsStatus' => 'setSmsStatus',
        'to' => 'setTo'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'callStatus' => 'getCallStatus',
        'ncStatus' => 'getNcStatus',
        'pinId' => 'getPinId',
        'smsStatus' => 'getSmsStatus',
        'to' => 'getTo'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['callStatus'] = $data['callStatus'] ?? null;
        $this->container['ncStatus'] = $data['ncStatus'] ?? null;
        $this->container['pinId'] = $data['pinId'] ?? null;
        $this->container['smsStatus'] = $data['smsStatus'] ?? null;
        $this->container['to'] = $data['to'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets callStatus
     *
     * @return string|null
     */
    public function getCallStatus()
    {
        return $this->container['callStatus'];
    }

    /**
     * Sets callStatus
     *
     * @param string|null $callStatus Call status.
     *
     * @return self
     */
    public function setCallStatus($callStatus)
    {
        $this->container['callStatus'] = $callStatus;

        return $this;
    }

    /**
     * Gets ncStatus
     *
     * @return string|null
     */
    public function getNcStatus()
    {
        return $this->container['ncStatus'];
    }

    /**
     * Sets ncStatus
     *
     * @param string|null $ncStatus Status of sent Number Lookup. Number Lookup status can have one of the following values: `NC_DESTINATION_UNKNOWN`, `NC_DESTINATION_REACHABLE`, `NC_DESTINATION_NOT_REACHABLE`, `NC_NOT_CONFIGURED`. If you get the `NC_NOT_CONFIGURED` status, you should contact your Account Manager. SMS will not be sent only if Number Lookup status is `NC_NOT_REACHABLE`.
     *
     * @return self
     */
    public function setNcStatus($ncStatus)
    {
        $this->container['ncStatus'] = $ncStatus;

        return $this;
    }

    /**
     * Gets pinId
     *
     * @return string|null
     */
    public function getPinId()
    {
        return $this->container['pinId'];
    }

    /**
     * Sets pinId
     *
     * @param string|null $pinId Sent PIN code ID.
     *
     * @return self
     */
    public function setPinId($pinId)
    {
        $this->container['pinId'] = $pinId;

        return $this;
    }

    /**
     * Gets smsStatus
     *
     * @return string|null
     */
    public function getSmsStatus()
    {
        return $this->container['smsStatus'];
    }

    /**
     * Sets smsStatus
     *
     * @param string|null $smsStatus Sent SMS status. Can have one of the following values: `MESSAGE_SENT`, `MESSAGE_NOT_SENT`.
     *
     * @return self
     */
    public function setSmsStatus($smsStatus)
    {
        $this->container['smsStatus'] = $smsStatus;

        return $this;
    }

    /**
     * Gets to
     *
     * @return string|null
     */
    public function getTo()
    {
        return $this->container['to'];
    }

    /**
     * Sets to
     *
     * @param string|null $to Phone number to which the 2FA message will be sent. Example: `41793026727`.
     *
     * @return self
     */
    public function setTo($to)
    {
        $this->container['to'] = $to;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    public function jsonSerialize()
    {
        return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}
